/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.client;

import com.ibm.hsc.rep.client.RQuery;
import com.ibm.hsc.rep.client.RResult;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.snia.wbemcmd.xml.SocketProvider;

public class RConnection {
    public static final int DEFAULT_PORT = 6060;
    String m_hostname;
    int m_port;
    Socket m_sock;
    ObjectInputStream m_ois;
    ObjectOutputStream m_oos;

    public RConnection(String string) {
        this.m_hostname = string;
        this.m_port = 6060;
    }

    public RConnection(String string, int n) {
        this.m_hostname = string;
        this.m_port = n;
    }

    public void open() throws Exception {
        SocketProvider socketProvider = SocketProvider.getProvider();
        InetAddress inetAddress = InetAddress.getByName(this.m_hostname);
        if (socketProvider != null) {
            this.m_sock = socketProvider.createSocket(inetAddress, this.m_port);
            System.out.println("RConnection: created socket from provider");
            System.out.println("RConnection: socket=" + this.m_sock);
        } else {
            this.m_sock = new Socket(this.m_hostname, this.m_port);
            System.out.println("RConnection: socket=" + this.m_sock);
        }
        this.m_ois = new ObjectInputStream(this.m_sock.getInputStream());
        this.m_oos = new ObjectOutputStream(this.m_sock.getOutputStream());
        System.out.println("socket connected: " + this.m_sock);
    }

    public RResult send(RQuery rQuery) throws Exception {
        this.m_oos.writeObject(rQuery);
        RResult rResult = (RResult)this.m_ois.readObject();
        return rResult;
    }

    public void close() {
        try {
            this.m_sock.close();
        }
        catch (Exception exception) {
            System.out.println("RConnection: failed to close socket");
        }
    }
}

